/**************************************************************************
*           Copyright (c) 2000, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    IPSecDrvOS_linux.c
*  Date:    05/09/2001
*
***************************************************************************
*
* A collection of OS-specific functions in the IPSEC Driver..
*   
*
***************************************************************************/
#include <linux/version.h>
#include <linux/config.h>
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS
#endif
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif

#include <linux/vmalloc.h>
#include <linux/sched.h>
#include <linux/string.h>

#include "GenDefs.h"
#include "Cniapi.h"
#include "IPSecDrvOSFunctions.h"


/*************************************************************************
* 
* AOLHack_Init
* 
* Description:
* 
*   Initializes the AOL Hack
* 
* Argument:
* 
*   (NONE) No Argument
* 
* Returns:
* 
*   void - 
* 
*************************************************************************/
void AOLHack_Init()
{

}


/*************************************************************************
* 
* AOLHack_GetBinding
* 
* Description:
* 
*   Retrieves the binding that the AOL adapter is using.
* 
* Argument:
* 
*   (NONE) No Argument
* 
* Returns:
* 
*   CNIBINDING - 
* 
*************************************************************************/
CNIBINDING AOLHack_GetBinding()
{
    return NULL;
}


/*************************************************************************
* 
* AOLHack_UpdateBindingInfo
* 
* Description:
* 
*   Updates the AOLBinding Info as necessary.
* 
* Argument:
* 
*   (IN/OUT) CNIBINDING b - The binding to check
* 
* Returns:
* 
*   void - 
* 
*************************************************************************/
void AOLHack_UpdateBindingInfo(CNIBINDING b)
{
}

/**************************************************************************** 
 *
 * OS specific time functions
 *
 ****************************************************************************/

/************************ UpdateTimeZoneOffset **********************
*
*    Purpose: Get our local timezone offset so we can use UTC 
*            time for calculating expiration periods.
*
*    Result is stored in the static variable s_tzOffset.
********************************************************************/
void UpdateTimeZoneOffset()
{
}

/************************ Get Current Time Procedure ************************
*
* Purpose:    To get the current local time.  It is represented as seconds since 
*           Jan 1 1970
*            
*
* parms:
*    none
*
* return:
*    cur_time, of type uint32
*
*****************************************************************************/
int32 GetCurrentTime ()
{
    time_t cur_time;
    ulong flags;
    
    save_flags(flags);
    cli();

    cur_time = CURRENT_TIME;

    restore_flags(flags);

    return (int32)cur_time;
}


/**************************************************************************** 
 *
 * Key expiration timer code
 *
 ****************************************************************************/

/* local variables */
static struct timer_list expiration_timerLinux;
static bool32 TimerExpire = TRUE;
static ULONG expiration_period;


/*************************************************************************
*
* expirationFunc
*
* Description:
*
*   callback when the timer expire
*
* Argument:
*
*   (NONE) unsigned long - (NOT USE)
*
* Returns:
*
*   NONE
*
*************************************************************************/
void expirationFunc(unsigned long ptr)
{
    TimerExpire = TRUE;
}

/*************************************************************************
* 
* IsKeyExpirationTimerExpired
* 
* Description:
* 
*   Checks if the Key expiration timer has completed
* 
* Argument:
* 
*   (NONE) No Argument
* 
* Returns:
* 
*   bool32 -  TRUE timer has completed
*             FALSE timer has not completed
* 
*************************************************************************/
bool32 IsKeyExpirationTimerExpired()
{
    if(TimerExpire)
    {
        /* ResetTimer */
        
        InitKeyExpirationTimer(expiration_period);
        
        return TRUE;
    }
            
    return FALSE;
}


/*************************************************************************
* 
* GetKeyExpirationTimerPeriod
* 
* Description:
* 
*   Gets the number of milliseconds between timer expiration
* 
* Argument:
* 
*   (NONE) No Argument
* 
* Returns:
* 
*   int32 - number of milliseconds between the timer signalling
* 
*************************************************************************/
int32 GetKeyExpirationTimerPeriod()
{
   return expiration_period;
}


/*************************************************************************
* 
* InitKeyExpirationTimer
* 
* Description:
* 
*   
* 
* Argument:
* 
*   (IN/OUT) int32 keyExpirationPeriod - The period to wait before timeing out.
* 
* Returns:
* 
*   uint32 - zero success
*            non-zero failure
* 
*************************************************************************/
uint32 InitKeyExpirationTimer(int32 keyExpirationPeriod)
{
    uint32 rc = 0;

    TimerExpire = FALSE;

    expiration_period = keyExpirationPeriod;
    
    init_timer(&expiration_timerLinux);
    
    expiration_timerLinux.function = expirationFunc;
    /* convert milliseconds into clock ticks*/
    expiration_timerLinux.expires = jiffies + ((HZ * keyExpirationPeriod)/1000);
    expiration_timerLinux.data = 0;
    
    add_timer(&expiration_timerLinux);

    return rc;
}


/*************************************************************************
* 
* CancelKeyExpirationTimer
* 
* Description:
* 
*   Cancels the expiration timer
* 
* Argument:
* 
*   (NONE) No Argument
* 
* Returns:
* 
*   uint32 - zero success
*            non-zero failure.
* 
*************************************************************************/
uint32 CancelKeyExpirationTimer()
{
    uint32 rc = 0;
    del_timer(&expiration_timerLinux);
    return rc;
}
