/**************************************************************************
*           Copyright (c) 2001, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    linux_os.h
*  Date:    04/25/2001
*
***************************************************************************
*
* Macros for handling differences in the linux kernel api.
*
***************************************************************************/
#ifndef _LINUX_OS_H
#define _LINUX_OS_H

#include <linux/version.h>

#include<linux/isdn.h>
#define IPPP_MAX_HEADER 10


#undef VERSION
/* a nice define to generate linux version numbers */
//#define VERSION(major,minor,patch) (((((major)<<8)+(minor))<<8)+(patch))
#define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#define device net_device
#define enet_statistics net_device_stats
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,4)
#include <asm/segment.h>
#define GET_USER(error,value,addr)										\
	error = get_user(value,addr)
#define COPY_FROM_USER(error,dest,src,size)								\
	error = copy_from_user(dest,src,size) ? -EFAULT : 0
#define PUT_USER(error,value,addr)										\
	error = put_user(value,addr)
#define COPY_TO_USER(error,dest,src,size)								\
	error = copy_to_user(dest,src,size) ?  -EFAULT : 0

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,5)
#include <asm/uaccess.h>
#endif

#else  /* 2.0.x and 2.1.x before 2.1.4 */

#define GET_USER(error,value,addr)										\
do {																	\
    error = verify_area (VERIFY_READ, (void *) addr, sizeof (value));	\
    if (error == 0)														\
        value = get_user(addr);											\
} while (0)

#define COPY_FROM_USER(error,dest,src,size)								\
do {																	\
    error = verify_area (VERIFY_READ, (void *) src, size);				\
    if (error == 0)														\
        memcpy_fromfs (dest, src, size);								\
} while (0)

#define PUT_USER(error,value,addr)										\
do {																	\
    error = verify_area (VERIFY_WRITE, (void *) addr, sizeof (value));	\
    if (error == 0)														\
        put_user (value, addr);											\
} while (0)

#define COPY_TO_USER(error,dest,src,size)								\
do {																	\
	error = verify_area (VERIFY_WRITE, (void *) dest, size);			\
	if(error == 0)														\
        memcpy_tofs (dest, src, size);									\
} while (0)

#endif

#endif
